const { contextBridge, ipcRenderer, shell } = require('electron');

contextBridge.exposeInMainWorld('electronAPI', {
    // Gestion des fichiers
    getFiles: () => ipcRenderer.invoke('get-files'),
    countFiles: () => ipcRenderer.invoke('count-files'),
    readFile: async (filePath, options = {}) => {
        try {
            return await ipcRenderer.invoke('read-file', filePath, options);
        } catch (error) {
            console.error('Erreur lors de la lecture du fichier :', error);
            return null;
        }
    },
    readJsonFile: (jsonFilePath) => ipcRenderer.invoke('read-json-file', jsonFilePath),
    writeJsonFile: (jsonFilePath, data) => ipcRenderer.invoke('write-json-file', jsonFilePath, data),
    readHtmlFile: (filePath) => ipcRenderer.invoke('read-html-file', filePath),
    openContainingFolder: (filePath) => ipcRenderer.invoke('open-containing-folder', filePath),

    // Indexation et recherche
    initializeIndexing: () => ipcRenderer.invoke('initialize-indexing'),
    searchFiles: (searchTerm) => ipcRenderer.invoke('search-files', searchTerm),
    backupFiles: () => ipcRenderer.invoke('backup-files'),

    // Actions de zoom
    zoomIn: () => ipcRenderer.send('zoom-in'),
    zoomOut: () => ipcRenderer.send('zoom-out'),

    // Gestion des logs
    sendLogMessage: (message) => ipcRenderer.send('log-message', message),
    onLogMessage: (callback) => ipcRenderer.on('log-message', (event, message) => callback(message)),

    // Fenêtres
    closeLogWindow: () => ipcRenderer.invoke('close-log-window'),

    showRefreshDialog: () => ipcRenderer.invoke('show-refresh-dialog'),

    // Gestion des événements personnalisés
    on: (channel, callback) => {
        const validChannels = ['directory-changed', 'log-message', 'zoom-in', 'zoom-out', 'show-close-button', 'close-log-window'];
        if (validChannels.includes(channel)) {
            ipcRenderer.on(channel, (event, ...args) => callback(...args));
        }
    },
    receive: (channel, func) => {
        const validChannels = ['zoom-in', 'zoom-out', 'update-file-counter', 'refresh-file-tree' , 'refresh-arborescence', 'log-message'];
        if (validChannels.includes(channel)) {
            ipcRenderer.on(channel, (event, ...args) => func(...args));
        }
    },

    getTranslations: async () => ipcRenderer.invoke('get-translations'),


    // Navigation externe
    openExternal: (url) => shell.openExternal(url),

    // Fermeture de l'application
    quitApp: () => ipcRenderer.send('quit-app'),
});
