// Supprimer les écouteurs supplémentaires inutiles
document.addEventListener('DOMContentLoaded', () => {
    console.log("Document chargé : La gestion de l'indexation est prête.");
});

document.addEventListener('DOMContentLoaded', () => {
    const modal = document.getElementById('indexingModal');

    // Écoute des mises à jour de l'indexation
    window.electronAPI.onLoadingUpdate((status) => {
        console.log('Statut reçu pour la modale :', status); // Vérifie si l'événement est bien reçu

        if (status === 'start') {
            console.log('Affichage de la modale.');
            modal.style.display = 'flex'; // Affiche la modale
        } else if (status === 'end' || status === 'error') {
            console.log('Masquage de la modale.');
            modal.style.display = 'none'; // Masque la modale
        }
    });

    // Fallback pour forcer le masquage après un certain temps
    setTimeout(() => {
        if (modal.style.display === 'flex') {
            console.log('Fallback : forcer le masquage de la modale après délai.');
            modal.style.display = 'none';
        }
    }, 6000); // 6 secondes pour garantir que la modale disparaît
});

window.electronAPI.onLoadingUpdate((status) => {
    const modal = document.getElementById('indexingModal');
    console.log('Statut reçu pour la modale :', status); // Log de débogage

    if (status === 'start') {
        console.log('Affichage de la modale.');
        modal.style.display = 'flex'; // Affiche la modale
    } else if (status === 'end' || status === 'error') {
        console.log('Masquage de la modale.');
        modal.style.display = 'none'; // Masque la modale
    }
});

function updateSelectedFileName(fileName) {
    const selectedFileName = document.getElementById('selectedFileName');
    selectedFileName.textContent = fileName || 'Aucun fichier sélectionné';
}

// Appel de la fonction quand un fichier est cliqué
document.getElementById('navigationPane').addEventListener('click', (event) => {
    const clickedElement = event.target.closest('.file-item'); // Suppose que chaque fichier a la classe "file-item"
    if (clickedElement) {
        const fileName = clickedElement.textContent.trim(); // Prend le texte du fichier cliqué
        updateSelectedFileName(fileName); // Met à jour le conteneur
    }
});





